/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import packages.components.button.SoftJButton;
import packages.components.dialogs.MessageBox;
import packages.components.frame.ExitableJFrame;
import packages.components.table.JDBCAdapter;
import packages.components.table.TableSorter;
import packages.image.ImageLoader;
import packages.utilities.FileHandler;
import packages.utilities.utilities;

public class ProdMaint
extends ExitableJFrame
implements ActionListener,
MouseMotionListener {
    private static final int CSVFormat = 13;
    private static final String RPT_LBL = " Reports";
    private static final String DATABASE_FILE = ".\\packaging.mdb";
    private static final String DATABASE_FILE_BCK = ".\\files\\db\\packaging.mdb";
    private static final String LICENCE_FILE = "licence";
    public static final String SELECT_ITEMS = "SELECT item_no as \"Item ID\",descr as Description, ptype as \"In/Out\", Supplier, Country, Exported, Product, UpdatedBy as \"Updated By\", theDate as \"Date\", Comments FROM Items";
    public static final String SELECT_PACKAGING = "SELECT item_no as \"Item ID\", packagID as \"Packaging ID\", descr as Description, packagType as\"Packaging Type\", Material  as\"Material Type\", Weight as \"Weight (kg)\", numPackagingPerSU as \"Amount of Packaging\", numItemsThisPack as \"Quantity of Items \", numItemsPerSU as \"Number of Items\", weight_per_Item as \"Weight per Item\", weight_per_SU as \"Weight per Shipping Unit\", Fate, UpdatedBy as \"Updated By\", theDate  as \"Date\", Comments from Packag ";
    private static String APP_PATH = "";
    private int ColItemID;
    private int ColDescription;
    private int ColInOut;
    private int ColSupplier;
    private int ColCountry;
    private int ColExported;
    private int ColProduct;
    private int ColUpdatedBy;
    private int ColDate;
    private int ColComments;
    private final boolean PRINT_TO_FILE = true;
    private static String LOG_FILE_DIR = ".\\files\\logfiles\\";
    private static String LOG_FILE_NAME = "PackProF.log";
    private static String AUDIT_LOG_FILE = "Audit.log";
    private String SQLItems = "";
    private String SQL_Packag = "";
    private String currentItem = "";
    private FileHandler fileHandler = new FileHandler();
    private Date dateTimeNow = new Date();
    public String sSortingColumn = "Item_no";
    private JLabel lbl_status = new JLabel("");
    private SoftJButton NewItemBtn;
    private SoftJButton EditItemBtn;
    private SoftJButton DeleteItemBtn;
    private SoftJButton PackNewBtn;
    private SoftJButton PackEditBtn;
    private SoftJButton PackDelBtn;
    private SoftJButton UploadBtn;
    public SoftJButton rptsButton;
    private SoftJButton dataBackUpButton;
    private utilities utilityObject = new utilities();
    private MessageBox messageBox;
    Cursor waitCurs = new Cursor(3);
    private Class[] columnClasses = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
    private String[] columnNames = new String[]{"Item Description", "Item Code", "Supplier", "Country", "Pen", "Telephone", "Purpose", "Buyer", "UOM", "Packaging", "Material", "Comments"};
    Vector Uploaddata = new Vector();
    Vector summedLines;
    TableSorter ItemsSorter;
    TableSorter PackagSorter;
    JDBCAdapter ItemsModel;
    JDBCAdapter PackagModel;
    JDBCAdapter rptModel;
    JScrollPane tableItemsPane;
    JScrollPane tablePackagPane;
    JTable ItemsTable;
    JTable PackagTable;
    Connection connection;
    ItemsDialog itemsDialog;
    PackagDialog packagDialog;
    ReportBuilder reportBuilder;
    UploadDialog uploadDialog;
    ReportsDialog reportsDialog;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu helpMenu;
    JMenuItem miNewItem;
    JMenuItem miEditItem;
    JMenuItem miDeleteItem;
    JMenuItem miRpts;
    JMenuItem miUpload;
    JMenuItem miBck;
    JMenuItem miNewPackag;
    JMenuItem miEditPackag;
    JMenuItem miDeletePackag;
    JMenuItem miExit;
    JMenuItem miHelpAbout;
    static String WINWORD;
    static String USERS_GUIDE;
    private int selectedItemRow = 0;
    private int selectedPackagRow = 0;

    public static void main(String[] args) {
        if (args.length > 1) {
            APP_PATH = args[0];
        }
        new ProdMaint(args);
    }

    public ProdMaint() {
    }

    public ProdMaint(String[] args) {
        super("PackProf v1.2 Demo");
        Vector Len12Prods = new Vector();
        try {
            ProdMaint.logMessageToFile("Starting PackProf v1.2 Demo: ");
            this.utilityObject = new utilities();
            this.utilityObject.setLF();
            FileHandler fh = new FileHandler();
            fh.zapFile(String.valueOf(APP_PATH).concat(String.valueOf(LOG_FILE_DIR)), LOG_FILE_NAME);
            FileHandler fh2 = new FileHandler();
            fh2.zapFile(String.valueOf(APP_PATH).concat(String.valueOf(LOG_FILE_DIR)), AUDIT_LOG_FILE);
            this.uploadDialog = new UploadDialog(this);
            this.reportsDialog = new ReportsDialog(this);
            this.setupButtons();
            File aFile = new File(String.valueOf(APP_PATH).concat(String.valueOf(LOG_FILE_DIR)), LOG_FILE_NAME);
            FileOutputStream fos = new FileOutputStream(aFile);
            System.setOut(new PrintStream(fos, true));
            if (!this.checkLicence()) {
                MessageBox mBox = new MessageBox(this, "PackProf v1.2 Demo", " The Software Licence is invalid. Please email packprof@softonomy.com to request a new one. ", false);
                mBox.setLocationAndShow(200, 200);
                ProdMaint.logMessageToFile("SYSTEM MESSAGE: Exiting ... ");
                System.exit(0);
            }
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            this.connection = DriverManager.getConnection("jdbc:odbc:PACKAGING", "", "");
            this.ItemsModel = new JDBCAdapter(this.connection);
            this.PackagModel = new JDBCAdapter(this.connection);
            BorderLayout panelBL = new BorderLayout();
            FlowLayout flowLayout = new FlowLayout(0);
            JPanel panelEdit = new JPanel();
            panelEdit.setLayout(panelBL);
            this.tableItemsPane = this.createItemsTable();
            this.ItemsSorter.setModel(this.ItemsModel);
            this.tablePackagPane = this.createPackagTable();
            this.PackagSorter.setModel(this.PackagModel);
            this.SQLItems = SELECT_ITEMS;
            this.SQLItems = String.valueOf(this.SQLItems).concat(String.valueOf(" ORDER BY Item_no"));
            this.rebuildItemsTable(this.SQLItems);
            this.setItemsTableWidths();
            this.ItemsTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ProdMaint.this.mouseClickAction(e);
                }
            });
            MouseAdapter listMouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getSource() == ProdMaint.this.ItemsTable.getTableHeader()) {
                        ProdMaint.this.sortTheItemColumn(e);
                    } else if (e.getSource() == ProdMaint.this.PackagTable.getTableHeader()) {
                        ProdMaint.this.sortThePackagColumn(e);
                    }
                }
            };
            JTableHeader th = this.ItemsTable.getTableHeader();
            th.addMouseListener(listMouseListener);
            th = this.PackagTable.getTableHeader();
            th.addMouseListener(listMouseListener);
            this.PackagTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ProdMaint.this.mouseClickAction(e);
                }
            });
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == ProdMaint.this.NewItemBtn) {
                        ProdMaint.this.newItemAction();
                    } else if (actionEvent.getSource() == ProdMaint.this.EditItemBtn) {
                        ProdMaint.this.setStatusLabel("");
                        int i = ProdMaint.this.ItemsTable.getSelectedRow();
                        if (i == -1) {
                            ProdMaint.this.setStatusLabel("Please select an Item");
                        } else {
                            ProdMaint.this.editItemAction(i);
                        }
                    } else if (actionEvent.getSource() == ProdMaint.this.DeleteItemBtn) {
                        ProdMaint.this.deleteItemAction();
                    } else if (actionEvent.getSource() == ProdMaint.this.UploadBtn) {
                        ProdMaint.this.uploadDialog.showUploadDialog();
                    } else if (actionEvent.getSource() == ProdMaint.this.rptsButton) {
                        ProdMaint.this.rptItem();
                    } else if (actionEvent.getSource() == ProdMaint.this.PackNewBtn) {
                        ProdMaint.this.NewPackag();
                    } else if (actionEvent.getSource() == ProdMaint.this.PackEditBtn) {
                        ProdMaint.this.EditPackag();
                    } else if (actionEvent.getSource() == ProdMaint.this.PackDelBtn) {
                        ProdMaint.this.DeletePackag();
                    } else if (actionEvent.getSource() == ProdMaint.this.dataBackUpButton) {
                        ProdMaint.this.dataBackUp();
                    }
                }
            };
            this.NewItemBtn.addActionListener(actionListener);
            this.EditItemBtn.addActionListener(actionListener);
            this.DeleteItemBtn.addActionListener(actionListener);
            this.UploadBtn.addActionListener(actionListener);
            this.rptsButton.addActionListener(actionListener);
            this.rptsButton.setEnabled(false);
            this.PackNewBtn.addActionListener(actionListener);
            this.PackEditBtn.addActionListener(actionListener);
            this.PackDelBtn.addActionListener(actionListener);
            this.dataBackUpButton.addActionListener(actionListener);
            JPanel buttonPanelItems = new JPanel(new GridLayout(0, 1));
            buttonPanelItems.add(this.NewItemBtn);
            buttonPanelItems.add(this.EditItemBtn);
            buttonPanelItems.add(this.DeleteItemBtn);
            buttonPanelItems.add(new JLabel(" "));
            buttonPanelItems.add(new JLabel(" "));
            buttonPanelItems.add(new JLabel(" "));
            buttonPanelItems.add(this.UploadBtn);
            buttonPanelItems.add(this.rptsButton);
            buttonPanelItems.add(this.dataBackUpButton);
            buttonPanelItems.add(new JLabel(" "));
            buttonPanelItems.add(new JLabel(" "));
            buttonPanelItems.add(new JLabel());
            this.fileMenu = new JMenu("File");
            this.miNewItem = new JMenuItem("New Item");
            this.miNewItem.addActionListener(this);
            this.fileMenu.add(this.miNewItem);
            this.miNewPackag = new JMenuItem("New Packaging");
            this.miNewPackag.addActionListener(this);
            this.fileMenu.add(this.miNewPackag);
            this.miRpts = new JMenuItem(RPT_LBL);
            this.miRpts.addActionListener(this);
            this.fileMenu.add(this.miRpts);
            this.fileMenu.add(new JSeparator());
            this.miDeleteItem = new JMenuItem("Delete Item");
            this.miDeleteItem.addActionListener(this);
            this.fileMenu.add(this.miDeleteItem);
            this.miDeletePackag = new JMenuItem("Delete Packaging");
            this.miDeletePackag.addActionListener(this);
            this.fileMenu.add(this.miDeletePackag);
            this.fileMenu.add(new JSeparator());
            this.miBck = new JMenuItem("Backup");
            this.miBck.addActionListener(this);
            this.fileMenu.add(this.miBck);
            this.fileMenu.add(new JSeparator());
            this.miUpload = new JMenuItem("Upload Data");
            this.miUpload.addActionListener(this);
            this.fileMenu.add(this.miUpload);
            this.fileMenu.add(new JSeparator());
            this.miExit = new JMenuItem("Exit");
            this.miExit.addActionListener(this);
            this.fileMenu.add(this.miExit);
            this.editMenu = new JMenu("Edit");
            this.miEditItem = new JMenuItem("Item");
            this.miEditItem.addActionListener(this);
            this.editMenu.add(this.miEditItem);
            this.miEditPackag = new JMenuItem("Packaging");
            this.miEditPackag.addActionListener(this);
            this.editMenu.add(this.miEditPackag);
            AbstractAction helpOperation = new AbstractAction("Help"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        new HelpAbout(ProdMaint.this, "Help", "HelpHelp.gif");
                    }
                    catch (Exception ec) {
                        ProdMaint.this.log(String.valueOf("ERROR NNN: ProdMaint: helpOperation: ").concat(String.valueOf(ec)));
                    }
                }
            };
            this.helpMenu = new JMenu("Help");
            this.helpMenu.add(helpOperation);
            this.helpMenu.add(new JSeparator());
            this.miHelpAbout = new JMenuItem("About");
            this.miHelpAbout.addActionListener(this);
            this.helpMenu.add(this.miHelpAbout);
            JMenuBar menubar = new JMenuBar();
            menubar.add(this.fileMenu);
            menubar.add(this.editMenu);
            menubar.add(this.helpMenu);
            JPanel gifsPanel = new JPanel(new BorderLayout());
            File myFile = new File(".", "softonomy.gif");
            DataInputStream fileIn = new DataInputStream(new FileInputStream(myFile));
            Image softonImage = ImageLoader.getImage(fileIn);
            ImageIcon softonIcon = new ImageIcon(softonImage);
            JLabel ImageLabel = new JLabel(softonIcon);
            gifsPanel.add((Component)ImageLabel, "West");
            myFile = new File(".", "genericlogo_small.gif");
            fileIn = new DataInputStream(new FileInputStream(myFile));
            Image genericImage = ImageLoader.getImage(fileIn);
            ImageIcon genericIcon = new ImageIcon(genericImage);
            ImageLabel = new JLabel(genericIcon);
            gifsPanel.add((Component)ImageLabel, "East");
            JPanel panelItems = new JPanel(new BorderLayout());
            panelItems.add((Component)menubar, "North");
            panelItems.add((Component)this.tableItemsPane, "Center");
            panelItems.add((Component)buttonPanelItems, "West");
            panelItems.add((Component)new JLabel(), "South");
            JPanel buttonPanelPackag = new JPanel(new GridLayout(0, 1));
            buttonPanelPackag.add(this.PackNewBtn);
            buttonPanelPackag.add(this.PackEditBtn);
            buttonPanelPackag.add(this.PackDelBtn);
            JPanel panelPackag = new JPanel(new BorderLayout());
            panelPackag.add((Component)this.tablePackagPane, "Center");
            panelPackag.add((Component)buttonPanelPackag, "West");
            panelPackag.add((Component)gifsPanel, "South");
            Container contentPane = this.getContentPane();
            contentPane.add((Component)panelItems, "North");
            contentPane.add((Component)panelPackag, "Center");
            JPanel statusPanel = new JPanel(new FlowLayout(0));
            statusPanel.add(this.lbl_status);
            contentPane.add((Component)statusPanel, "South");
            this.getPackag(0);
            this.setOKToExit(true);
            this.setResizable(true);
            ((Component)this).setSize(1000, 700);
            this.rptModel = new JDBCAdapter(this.connection);
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
            ((Component)this).setVisible(true);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 049: ProdMaint: Constructor error ").concat(String.valueOf(ex.toString())));
        }
    }

    private void deleteItemAction() {
        String SQL = "";
        try {
            this.getItemsTableWidths();
            int rowNum = this.ItemsTable.getSelectedRow();
            String Item = (String)this.ItemsTable.getValueAt(rowNum, 0);
            this.messageBox = new MessageBox(this, "Confirm Delete", String.valueOf(String.valueOf("   Warning: You are about to delete Item ").concat(String.valueOf(Item))).concat(String.valueOf(". Do you want to proceed?")), true);
            this.messageBox.setLocationAndShow(200, 200);
            if (this.messageBox.GetMessageBoxAnswer() == 1 && rowNum >= 0) {
                SQL = String.valueOf(String.valueOf("DELETE FROM Items WHERE Item_no = '").concat(String.valueOf(Item))).concat(String.valueOf("'"));
                this.doNonSelect(SQL);
                SQL = String.valueOf(String.valueOf("DELETE FROM PACKAG WHERE Item_no = '").concat(String.valueOf(Item))).concat(String.valueOf("'"));
                this.doNonSelect(SQL);
                this.rebuildItemsTable();
                this.rebuildPackagTable();
                this.setItemsTableWidths();
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 050: ProdMaint: deleteItemAction error ").concat(String.valueOf(ex.toString())));
        }
    }

    public void log(String sMsg) {
        try {
            this.fileHandler.appendToFile(LOG_FILE_DIR, LOG_FILE_NAME, sMsg);
            this.setStatusLabel(sMsg);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("ERROR 051: ProdMaint: log: error printing ").concat(String.valueOf(sMsg))).concat(String.valueOf("  "))).concat(String.valueOf(ex)));
        }
    }

    private void reLoadData(MouseEvent e) {
        int viewColumn = this.ItemsTable.getColumnModel().getColumnIndexAtX(e.getX());
        ProdMaint.logMessageToFile(String.valueOf("ERROR NNN: ProdMaint: reLoadData: viewColumn =").concat(String.valueOf(viewColumn)));
    }

    private void newItemAction() {
        try {
            if (this.itemsDialog == null) {
                this.itemsDialog = new ItemsDialog(this);
            }
            this.itemsDialog.showItemsDialog(null);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 052: ProdMaint: newItemAction error  ").concat(String.valueOf(ex.toString())));
        }
    }

    public void setStatusLabel(String str) {
        try {
            this.lbl_status.setText(String.valueOf("  ").concat(String.valueOf(str)));
            this.repaint();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 053: ProdMaint: setStatusLabel error  ").concat(String.valueOf(ex)));
        }
    }

    public JScrollPane createItemsTable() {
        JScrollPane scrollpane = null;
        try {
            try {
                this.ItemsSorter = new TableSorter();
                this.ItemsTable = new JTable(this.ItemsSorter);
                this.ItemsTable.setAutoResizeMode(0);
                scrollpane = new JScrollPane(this.ItemsTable);
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 054: ProdMaint: createItemsTable ").concat(String.valueOf(ex.toString())));
                Object var4_3 = null;
                return scrollpane;
            }
            Object var4_2 = null;
            return scrollpane;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return scrollpane;
        }
    }

    public JScrollPane createPackagTable() {
        JScrollPane scrollpane = null;
        try {
            try {
                this.PackagSorter = new TableSorter();
                this.PackagTable = new JTable(this.PackagSorter);
                this.PackagTable.setAutoResizeMode(0);
                this.PackagSorter.addMouseListenerToHeaderInTable(this.PackagTable);
                scrollpane = new JScrollPane(this.PackagTable);
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 055: ProdMaint: createPackagTable ").concat(String.valueOf(ex.toString())));
                Object var4_3 = null;
                return scrollpane;
            }
            Object var4_2 = null;
            return scrollpane;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return scrollpane;
        }
    }

    private void sortTheItemColumn(MouseEvent e) {
        try {
            this.getItemsTableWidths();
            TableColumnModel columnModel = this.ItemsTable.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.ItemsTable.convertColumnIndexToModel(viewColumn);
            this.sSortingColumn = "";
            switch (column) {
                case 0: {
                    this.sSortingColumn = "Item_no";
                    break;
                }
                case 1: {
                    this.sSortingColumn = "descr";
                    break;
                }
                case 2: {
                    this.sSortingColumn = "ptype";
                    break;
                }
                case 3: {
                    this.sSortingColumn = "Supplier";
                    break;
                }
                case 4: {
                    this.sSortingColumn = "Country";
                    break;
                }
                case 5: {
                    this.sSortingColumn = "Exported";
                    break;
                }
                case 6: {
                    this.sSortingColumn = "Product";
                    break;
                }
                case 7: {
                    this.sSortingColumn = "UpdatedBy";
                    break;
                }
                case 8: {
                    this.sSortingColumn = "theDate";
                    break;
                }
                case 9: {
                    this.sSortingColumn = "Comments";
                }
            }
            this.SQLItems = SELECT_ITEMS;
            this.SQLItems = String.valueOf(this.SQLItems).concat(String.valueOf(String.valueOf(" ORDER by ").concat(String.valueOf(this.sSortingColumn))));
            Thread t = new Thread(){

                public void run() {
                    try {
                        ProdMaint.this.ItemsTable.setVisible(false);
                        Thread.currentThread();
                        Thread.sleep(10L);
                        ProdMaint.this.rebuildItemsTable(ProdMaint.this.SQLItems);
                        ProdMaint.this.setItemsTableWidths();
                        ProdMaint.this.ItemsTable.setVisible(true);
                        ProdMaint.this.setStatusLabel("Ready");
                        ProdMaint.this.getContentPane().setCursor(new Cursor(0));
                        ProdMaint.this.ItemsTable.setCursor(new Cursor(0));
                        ProdMaint.this.repaint();
                    }
                    catch (Exception ex) {
                        ProdMaint.logMessageToFile(String.valueOf("ERROR 056: ProdMaint: sortTheItemColumn: inner thread run error ").concat(String.valueOf(ex.toString())));
                    }
                }
            };
            t.setPriority(1);
            Thread.currentThread().setPriority(10);
            t.start();
            ((Component)this).setCursor(this.waitCurs);
            this.getContentPane().setCursor(this.waitCurs);
            this.ItemsTable.setCursor(this.waitCurs);
            this.getContentPane().repaint();
            this.setStatusLabel("Please Wait, Sorting....");
            this.repaint();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 057: ProdMaint: sortTheItemColumn ").concat(String.valueOf(ex.toString())));
        }
    }

    private void sortThePackagColumn(MouseEvent e) {
        try {
            TableColumnModel columnModel = this.PackagTable.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.PackagTable.convertColumnIndexToModel(viewColumn);
            this.sSortingColumn = "";
            switch (column) {
                case 0: {
                    this.sSortingColumn = "Item_no";
                    break;
                }
                case 1: {
                    this.sSortingColumn = "packagID";
                    break;
                }
                case 2: {
                    this.sSortingColumn = "descr";
                    break;
                }
                case 3: {
                    this.sSortingColumn = "packagType";
                    break;
                }
                case 4: {
                    this.sSortingColumn = "Material";
                    break;
                }
                case 5: {
                    this.sSortingColumn = "Weight";
                    break;
                }
                case 6: {
                    this.sSortingColumn = "numPackagingPerSU";
                    break;
                }
                case 7: {
                    this.sSortingColumn = "numItemsThisPack";
                    break;
                }
                case 8: {
                    this.sSortingColumn = "numItemsPerSU";
                    break;
                }
                case 9: {
                    this.sSortingColumn = "weight_per_Item";
                    break;
                }
                case 10: {
                    this.sSortingColumn = "weight_per_SU";
                    break;
                }
                case 11: {
                    this.sSortingColumn = "Fate";
                    break;
                }
                case 12: {
                    this.sSortingColumn = "UpdatedBy";
                    break;
                }
                case 13: {
                    this.sSortingColumn = "theDate";
                    break;
                }
                case 14: {
                    this.sSortingColumn = "Comments";
                }
            }
            this.SQL_Packag = SELECT_PACKAGING;
            this.SQL_Packag = String.valueOf(this.SQL_Packag).concat(String.valueOf(String.valueOf(String.valueOf(" where Item_no='").concat(String.valueOf(this.currentItem))).concat(String.valueOf("'"))));
            this.SQL_Packag = String.valueOf(this.SQL_Packag).concat(String.valueOf(String.valueOf(" ORDER by ").concat(String.valueOf(this.sSortingColumn))));
            Thread t = new Thread(){

                public void run() {
                    try {
                        ProdMaint.this.PackagTable.setVisible(false);
                        Thread.currentThread();
                        Thread.sleep(10L);
                        ProdMaint.this.rebuildPackagTable(ProdMaint.this.SQL_Packag);
                        ProdMaint.this.PackagTable.setVisible(true);
                        ProdMaint.this.setStatusLabel("Ready");
                        ProdMaint.this.getContentPane().setCursor(new Cursor(0));
                        ProdMaint.this.PackagTable.setCursor(new Cursor(0));
                        ProdMaint.this.repaint();
                    }
                    catch (Exception ex) {
                        ProdMaint.logMessageToFile(String.valueOf("ERROR 058: ProdMaint: sortThePackagColumn: inner thread run error  ").concat(String.valueOf(ex.toString())));
                    }
                }
            };
            t.setPriority(1);
            Thread.currentThread().setPriority(10);
            t.start();
            ((Component)this).setCursor(this.waitCurs);
            this.getContentPane().setCursor(this.waitCurs);
            this.PackagTable.setCursor(this.waitCurs);
            this.getContentPane().repaint();
            this.setStatusLabel("Please Wait, Sorting....");
            this.repaint();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 059: ProdMaint: sortThePackagColumn: ").concat(String.valueOf(ex.toString())));
        }
    }

    private void reInitialiseDatabase(boolean newModel) {
        try {
            this.rptModel.close();
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            this.connection = null;
            this.connection = DriverManager.getConnection("jdbc:odbc:PACKAGING", "", "");
            if (newModel) {
                this.rptModel = new JDBCAdapter(this.connection);
            } else {
                this.rptModel.setConnection(this.connection);
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 060: ProdMaint: reInitialiseDatabase ").concat(String.valueOf(ex.toString())));
        }
    }

    private void mouseClickAction(MouseEvent e) {
        this.setStatusLabel("");
        try {
            if (e.getSource() == this.ItemsTable) {
                this.PackEditBtn.setEnabled(true);
                this.PackDelBtn.setEnabled(true);
                int i = this.ItemsTable.getSelectedRow();
                if (i >= 0 && e.getClickCount() == 2) {
                    this.editItemAction(i);
                } else if (i >= 0 && e.getClickCount() == 1) {
                    this.getPackag(i);
                }
            } else if (e.getSource() == this.PackagTable) {
                this.PackEditBtn.setEnabled(true);
                this.PackDelBtn.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 061: ProdMaint: mouseClickAction ").concat(String.valueOf(ex.toString())));
        }
    }

    private void editItemAction(int i) {
        try {
            boolean j = false;
            Vector<String> vect = new Vector<String>();
            String Item = (String)this.ItemsModel.getValueAt(i, 0);
            String descr = (String)this.ItemsModel.getValueAt(i, 1);
            String sType = (String)this.ItemsModel.getValueAt(i, 2);
            String sSupl = (String)this.ItemsModel.getValueAt(i, 3);
            String Country = (String)this.ItemsModel.getValueAt(i, 4);
            String Exported = (String)this.ItemsModel.getValueAt(i, 5);
            String Product = (String)this.ItemsModel.getValueAt(i, 6);
            String UpdatedBy = (String)this.ItemsModel.getValueAt(i, 7);
            String theDate = (String)this.ItemsModel.getValueAt(i, 8);
            String Comments = (String)this.ItemsModel.getValueAt(i, 9);
            vect.addElement(Item);
            vect.addElement(descr);
            vect.addElement(sType);
            vect.addElement(sSupl);
            vect.addElement(Country);
            vect.addElement(Exported);
            vect.addElement(Product);
            vect.addElement(UpdatedBy);
            vect.addElement(theDate);
            vect.addElement(Comments);
            if (this.itemsDialog == null) {
                this.itemsDialog = new ItemsDialog(this);
            }
            this.itemsDialog.newMode = false;
            this.itemsDialog.showItemsDialog(vect);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 062: ProdMaint: mouseClickAction ").concat(String.valueOf(ex.toString())));
        }
    }

    public void doNonSelect(String sql) {
        try {
            this.ItemsModel.doNonSelect(sql);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 063: ProdMaint: doNonSelect ").concat(String.valueOf(ex.toString())));
        }
    }

    public void doPackagNonSelect(String sql) {
        try {
            this.PackagModel.doNonSelect(sql);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 064: ProdMaint: doPackagNonSelect ").concat(String.valueOf(ex.toString())));
        }
    }

    public void rebuildItemsTable() {
        try {
            this.ItemsModel.executeQuery(this.SQLItems);
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 065: ProdMaint: rebuildItemsTable ").concat(String.valueOf(ex.toString())));
        }
    }

    public void rebuildItemsTable(String sql) {
        try {
            this.ItemsModel.executeQuery(sql);
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 066: ProdMaint: rebuildItemsTable ").concat(String.valueOf(ex.toString())));
        }
    }

    public void getPackag(int i) {
        try {
            if (this.ItemsModel.getRowCount() <= i) {
                return;
            }
            this.currentItem = (String)this.ItemsModel.getValueAt(i, 0);
            this.SQL_Packag = SELECT_PACKAGING;
            this.SQL_Packag = String.valueOf(this.SQL_Packag).concat(String.valueOf(String.valueOf(String.valueOf(" where Item_no='").concat(String.valueOf(this.currentItem))).concat(String.valueOf("'"))));
            this.SQL_Packag = String.valueOf(this.SQL_Packag).concat(String.valueOf(" ORDER BY Item_no, PackagID"));
            this.PackagModel.executeQuery(this.SQL_Packag);
            this.selectedItemRow = 0;
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 067: ProdMaint: getPackag: ").concat(String.valueOf(ex.toString())));
        }
    }

    public void rebuildPackagTable() {
        try {
            this.PackagModel.executeQuery(this.SQL_Packag);
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 068: ProdMaint: rebuildPackagTable ").concat(String.valueOf(ex.toString())));
        }
    }

    public void rebuildPackagTable(String sql) {
        try {
            this.PackagModel.executeQuery(sql);
            this.PackEditBtn.setEnabled(false);
            this.PackDelBtn.setEnabled(false);
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 069: ProdMaint: rebuildPackagTable(str) ").concat(String.valueOf(ex.toString())));
        }
    }

    private void NewPackag() {
        try {
            int i = this.ItemsTable.getSelectedRow();
            if (i >= 0) {
                Vector value;
                if (this.packagDialog == null) {
                    this.packagDialog = new PackagDialog(this);
                }
                String Item = (String)this.ItemsModel.getValueAt(i, 0);
                String sql = String.valueOf(String.valueOf("SELECT max( PackagID ) from Packag where item_no = '").concat(String.valueOf(Item))).concat(String.valueOf("'"));
                this.rptModel.executeQuery(sql);
                Vector v = this.rptModel.rows;
                String PackagNum = "0";
                if (v != null & v.size() > 0 && (value = (Vector)v.elementAt(0)) != null & value.size() > 0) {
                    PackagNum = (String)value.elementAt(0);
                }
                if (PackagNum == null || PackagNum.equals("")) {
                    PackagNum = "0";
                }
                if (!PackagNum.equals("")) {
                    int num = Integer.parseInt(String.valueOf(PackagNum));
                    PackagNum = String.valueOf(++num);
                }
                this.packagDialog.newMode = true;
                this.setPackageInputItemFlag();
                this.packagDialog.showPackagDialog(Item, this.ItemsModel.getRowCount(), PackagNum);
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 070: ProdMaint: NewPackag: ").concat(String.valueOf(ex.toString())));
        }
    }

    private void EditPackag() {
        try {
            this.selectedPackagRow = this.PackagTable.getSelectedRow();
            if (this.selectedPackagRow == -1) {
                this.setStatusLabel("Please select a row in the Packaging table");
                return;
            }
            String sPackagNo = this.PackagTable.getValueAt(this.selectedPackagRow, 1).toString();
            String SQL_Packag = SELECT_PACKAGING;
            SQL_Packag = String.valueOf(SQL_Packag).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" where Item_no='").concat(String.valueOf(this.currentItem))).concat(String.valueOf("' AND PackagID='"))).concat(String.valueOf(sPackagNo))).concat(String.valueOf("'"))));
            this.rptModel.executeQuery(SQL_Packag);
            Vector v = this.rptModel.rows;
            Vector onePackagData = (Vector)v.elementAt(0);
            if (this.selectedItemRow >= 0) {
                Vector<String> thisPackag = new Vector<String>();
                thisPackag.addElement(onePackagData.elementAt(0).toString());
                thisPackag.addElement(onePackagData.elementAt(1).toString());
                thisPackag.addElement(onePackagData.elementAt(2).toString());
                thisPackag.addElement(onePackagData.elementAt(3).toString());
                thisPackag.addElement(onePackagData.elementAt(4).toString());
                thisPackag.addElement(onePackagData.elementAt(5).toString());
                thisPackag.addElement(onePackagData.elementAt(6).toString());
                thisPackag.addElement(onePackagData.elementAt(7).toString());
                thisPackag.addElement(onePackagData.elementAt(8).toString());
                thisPackag.addElement(onePackagData.elementAt(9).toString());
                thisPackag.addElement(onePackagData.elementAt(10).toString());
                thisPackag.addElement(onePackagData.elementAt(11).toString());
                thisPackag.addElement(onePackagData.elementAt(12).toString());
                thisPackag.addElement(onePackagData.elementAt(13).toString());
                thisPackag.addElement(onePackagData.elementAt(14).toString());
                if (this.packagDialog == null) {
                    this.packagDialog = new PackagDialog(this);
                }
                this.packagDialog.newMode = false;
                this.setPackageInputItemFlag();
                this.packagDialog.showPackagDialog(thisPackag, this.PackagModel.getRowCount());
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 071: ProdMaint: EditPackag: ").concat(String.valueOf(ex.toString())));
        }
    }

    private void DeletePackag() {
        String SQL = "";
        int ItemRowNum = this.ItemsTable.getSelectedRow();
        int PackagRowNum = this.PackagTable.getSelectedRow();
        String Item = (String)this.ItemsModel.getValueAt(ItemRowNum, 0);
        String PackagID = (String)this.PackagTable.getValueAt(PackagRowNum, 1);
        try {
            this.messageBox = new MessageBox(this, "Delete", String.valueOf(String.valueOf(String.valueOf(String.valueOf("   Warning: You are about to delete Packaging ").concat(String.valueOf(PackagID))).concat(String.valueOf(" from Item "))).concat(String.valueOf(Item))).concat(String.valueOf(". Do you want to proceed?")), true);
            this.messageBox.setLocationAndShow(200, 300);
            if (this.messageBox.GetMessageBoxAnswer() == 1 && PackagRowNum >= 0 && ItemRowNum >= 0) {
                SQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf("DELETE FROM Packag WHERE Item_no = '").concat(String.valueOf(Item))).concat(String.valueOf("' and PackagID = '"))).concat(String.valueOf(PackagID))).concat(String.valueOf("'"));
                this.doNonSelect(SQL);
                this.rebuildPackagTable();
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR NNN: ProdMaint: DeleteItem error: ").concat(String.valueOf(ex.toString())));
        }
    }

    private void rptItem() {
        try {
            this.reportsDialog.showReportsDialog();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 072: ProdMaint: rptItem: ").concat(String.valueOf(ex.toString())));
        }
    }

    public void doReport() {
        try {
            this.reInitialiseDatabase(true);
            if (this.reportBuilder == null) {
                this.reportBuilder = new ReportBuilder(this.rptModel, this, this.Uploaddata);
            }
            String[][] parsedInputData = this.utilityObject.MakeNameValuePairFromTildaString(this.Uploaddata);
            this.reportBuilder.doNewReport(parsedInputData);
            ProdMaint.logMessageToFile("SYSTEM MESSAGE: Report Complete. ");
            this.setStatusLabel("Report Complete ");
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 073: ProdMaint: doReport ").concat(String.valueOf(ex.toString())));
        }
    }

    public void mouseMoved(MouseEvent evt) {
        try {
            Component comp = (Component)evt.getSource();
            if (comp instanceof JMenu) {
                this.fileMenu.setBackground(Color.lightGray);
                this.helpMenu.setBackground(Color.lightGray);
                this.editMenu.setBackground(Color.lightGray);
                comp.setBackground(Color.blue);
                comp.requestFocus();
                comp.repaint();
            } else {
                this.fileMenu.setBackground(Color.lightGray);
                this.helpMenu.setBackground(Color.lightGray);
                this.editMenu.setBackground(Color.lightGray);
            }
            this.repaint();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 074: ProdMaint: mouseMoved: ").concat(String.valueOf(ex.toString())));
        }
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Component comp = (Component)e.getSource();
            if (comp == this.miNewItem) {
                this.newItemAction();
            } else if (comp == this.miEditItem) {
                this.selectedItemRow = this.ItemsTable.getSelectedRow();
                this.editItemAction(this.selectedItemRow);
            } else if (comp == this.miDeleteItem) {
                this.deleteItemAction();
            } else if (comp == this.miUpload) {
                this.uploadDialog.showUploadDialog();
            } else if (comp == this.miRpts) {
                this.rptItem();
            } else if (comp == this.miBck) {
                this.dataBackUp();
            } else if (comp == this.miNewItem) {
                this.newItemAction();
            } else if (comp == this.miEditItem) {
                this.EditPackag();
            } else if (comp == this.miDeleteItem) {
                this.DeletePackag();
            } else if (comp == this.miExit) {
                ProdMaint.logMessageToFile("SYSTEM MESSAGE: Exiting normally ... ");
                System.exit(0);
            } else if (comp == this.miHelpAbout) {
                this.helpAbout();
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 075: ProdMaint: actionPerformed ").concat(String.valueOf(ex.toString())));
        }
    }

    public static void logMessageToFile(String msg) {
        FileHandler fh = new FileHandler();
        fh.appendToFile(String.valueOf(APP_PATH).concat(String.valueOf(LOG_FILE_DIR)), LOG_FILE_NAME, String.valueOf(String.valueOf(msg).concat(String.valueOf(": "))).concat(String.valueOf(new Date())));
    }

    public static void logMessageToAuditFile(String msg) {
        FileHandler fh = new FileHandler();
        fh.appendToFile(String.valueOf(APP_PATH).concat(String.valueOf(LOG_FILE_DIR)), AUDIT_LOG_FILE, msg);
    }

    void setItemsTableWidths() {
        try {
            if (this.ColItemID == 0) {
                return;
            }
            this.ItemsTable.getColumnModel().getColumn(0).setWidth(this.ColItemID);
            this.ItemsTable.getColumnModel().getColumn(1).setWidth(this.ColDescription);
            this.ItemsTable.getColumnModel().getColumn(2).setWidth(this.ColInOut);
            this.ItemsTable.getColumnModel().getColumn(3).setWidth(this.ColSupplier);
            this.ItemsTable.getColumnModel().getColumn(4).setWidth(this.ColCountry);
            this.ItemsTable.getColumnModel().getColumn(5).setWidth(this.ColExported);
            this.ItemsTable.getColumnModel().getColumn(6).setWidth(this.ColProduct);
            this.ItemsTable.getColumnModel().getColumn(7).setWidth(this.ColUpdatedBy);
            this.ItemsTable.getColumnModel().getColumn(8).setWidth(this.ColDate);
            this.ItemsTable.getColumnModel().getColumn(9).setWidth(this.ColComments);
            this.ItemsTable.revalidate();
            this.ItemsTable.repaint();
            this.repaint();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 076: ProdMaint: setItemsTableWidths ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(": "))).concat(String.valueOf(new Date())));
        }
    }

    void getItemsTableWidths() {
        try {
            this.ColItemID = this.ItemsTable.getColumnModel().getColumn(0).getWidth();
            this.ColDescription = this.ItemsTable.getColumnModel().getColumn(1).getWidth();
            this.ColInOut = this.ItemsTable.getColumnModel().getColumn(2).getWidth();
            this.ColSupplier = this.ItemsTable.getColumnModel().getColumn(3).getWidth();
            this.ColCountry = this.ItemsTable.getColumnModel().getColumn(4).getWidth();
            this.ColExported = this.ItemsTable.getColumnModel().getColumn(5).getWidth();
            this.ColProduct = this.ItemsTable.getColumnModel().getColumn(6).getWidth();
            this.ColUpdatedBy = this.ItemsTable.getColumnModel().getColumn(7).getWidth();
            this.ColDate = this.ItemsTable.getColumnModel().getColumn(8).getWidth();
            this.ColComments = this.ItemsTable.getColumnModel().getColumn(9).getWidth();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 077: ProdMaint: getItemsTableWidths: ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(": "))).concat(String.valueOf(new Date())));
        }
    }

    private void dataBackUp() {
        String SQL = "";
        try {
            this.copy(DATABASE_FILE, DATABASE_FILE_BCK);
            this.setStatusLabel("A Database Backup has been performed.");
            ProdMaint.logMessageToFile("SYSTEM OK: Backup performed");
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 078: ProdMaint: dataBackUp: ").concat(String.valueOf(ex.toString())));
        }
    }

    public void copyFile(File f1, File f2) throws IOException {
        int r;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[2048];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
    }

    public void copy(File f1, File f2) throws IOException {
        if (f1.isDirectory()) {
            f2.mkdirs();
            String[] files = f1.list();
            for (int i = 0; i < files.length; ++i) {
                this.copy(new File(f1, files[i]), new File(f2, files[i]));
            }
        } else {
            this.copyFile(f1, f2);
        }
    }

    public void copy(String f1, String f2) throws IOException {
        this.copy(new File(f1), new File(f2));
    }

    private void helpAbout() {
        new HelpAbout(this, "Help About", "HelpAbout.gif");
    }

    private void setupButtons() {
        this.lbl_status = new JLabel("");
        this.NewItemBtn = new SoftJButton(" New Item ");
        this.EditItemBtn = new SoftJButton(" Edit Item ");
        this.DeleteItemBtn = new SoftJButton("    Delete  Item ");
        Color c = new Color(105, 155, 244);
        this.PackNewBtn = new SoftJButton(" Packaging - New ", c);
        Font f = new Font("Dialog", 1, 12);
        this.PackNewBtn.setTheFont(f);
        this.PackEditBtn = new SoftJButton(" Packaging - Edit ", c);
        this.PackEditBtn.setTheFont(f);
        this.PackDelBtn = new SoftJButton(" Packaging - Delete ", c);
        this.PackDelBtn.setTheFont(f);
        c = new Color(0, 119, 255);
        this.UploadBtn = new SoftJButton(" Upload Data ", c);
        c = new Color(0, 119, 255);
        this.rptsButton = new SoftJButton("Reports", c);
        c = new Color(0, 119, 255);
        this.dataBackUpButton = new SoftJButton(" Backup data", c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLicence() {
        boolean OK = true;
        try {
            try {
                ProdMaint.logMessageToFile("SYSTEM MESSAGE: Checking for a valid PackProf Software Licence: ");
                File file = new File(LICENCE_FILE);
                ProdMaint.logMessageToAuditFile("PackProf v1.2 Demo");
                ProdMaint.logMessageToAuditFile("Calculation Audit Log");
                if (!file.exists()) {
                    ProdMaint.logMessageToFile("ERROR 200: PackProf licence file does not exist. ");
                    MessageBox mBox = new MessageBox(this, "PackProf v1.2 Demo", " A Software Licence cannot be found. Please email packprof@softonomy.com to request one. ", false);
                    mBox.setLocationAndShow(300, 300);
                    ProdMaint.logMessageToFile("SYSTEM MESSAGE: Exiting ... ");
                    System.exit(0);
                }
                if (file.exists()) {
                    Date now = new Date();
                    FileInputStream fis = new FileInputStream(LICENCE_FILE);
                    DataInputStream dis = new DataInputStream(fis);
                    Long lFromFile = new Long(dis.readLong());
                    long adjustedLong = lFromFile - new Long(this.utilityObject.padString("", 16, '2'));
                    Date sDate = new Date(adjustedLong);
                    if (now.after(sDate)) {
                        OK = false;
                        ProdMaint.logMessageToFile("ERROR 079: The PackProf v1.2 Demo Licence is INVALID!: ");
                        boolean bl = OK;
                        return OK;
                    }
                    ProdMaint.logMessageToFile("SYSTEM MESSAGE: PackProf v1.2 Demo Licence is valid.");
                    this.setStatusLabel("Ready");
                }
            }
            catch (Exception exc) {
                ProdMaint.logMessageToFile("ERROR 080: ProdMaint: checkLicence: ");
                return false;
            }
        }
        catch (Throwable throwable) {
            return OK;
        }
        Object var12_12 = null;
        return OK;
    }

    private void setPackageInputItemFlag() {
        boolean inputitem = false;
        int i = this.ItemsTable.getSelectedRow();
        if (i != -1) {
            String sType = (String)this.ItemsModel.getValueAt(i, 2);
            inputitem = sType.equalsIgnoreCase("Input");
        }
        this.packagDialog.setCurrentItemIsAnInputItem(!inputitem);
    }
}

