/*
 * Decompiled with CFR 0.152.
 */
package packages.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ImageLoader {
    private ImageLoader() {
    }

    public static Image getImage(Class relativeClass, String filename) {
        Image returnValue = null;
        InputStream is = relativeClass.getResourceAsStream(filename);
        if (is != null) {
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int ch;
                while ((ch = bis.read()) != -1) {
                    baos.write(ch);
                }
                returnValue = Toolkit.getDefaultToolkit().createImage(baos.toByteArray());
            }
            catch (IOException exception) {
                ProdMaint.logMessageToFile("Error loading: ".concat(String.valueOf(String.valueOf(filename))));
            }
        }
        return returnValue;
    }

    public static Image getImage(InputStream is) {
        Image returnValue = null;
        if (is != null) {
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int ch;
                while ((ch = bis.read()) != -1) {
                    baos.write(ch);
                }
                returnValue = Toolkit.getDefaultToolkit().createImage(baos.toByteArray());
            }
            catch (IOException exception) {
                ProdMaint.logMessageToFile("ImageLoader, Error loading file");
            }
        }
        return returnValue;
    }
}

