/*
 * Decompiled with CFR 0.152.
 */
package xlrd;

import java.io.File;
import xlrd.CSV;
import xlrd.Workbook;
import xlrd.XML;

public class Demo {
    public static final int CSVFormat = 13;
    public static final int XMLFormat = 14;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
            System.err.println("                 CSV -version");
            System.exit(1);
        }
        if (args[0].equals("-version")) {
            System.out.println(String.valueOf("v").concat(String.valueOf(Workbook.getVersion())));
            System.exit(0);
        }
        String encoding = "UTF8";
        int format = 13;
        String file = args[0];
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-unicode")) {
                encoding = "UnicodeBig";
                continue;
            }
            if (args[i].equals("-xml")) {
                format = 14;
                continue;
            }
            if (args[i].equals("-csv")) {
                format = 13;
                continue;
            }
            System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
            System.exit(1);
        }
        file = args[args.length - 1];
        try {
            Workbook w = Workbook.getWorkbook(new File(file));
            if (format == 13) {
                CSV cSV = new CSV(w, System.out, encoding);
            } else if (format == 14) {
                XML xML = new XML(w, System.out, encoding);
            }
            w.close();
        }
        catch (Throwable t) {
            System.out.println(t.toString());
            t.printStackTrace();
        }
    }
}

