/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import xlrd.biff.BiffException;
import xlrd.biff.IntegerHelper;

final class CompoundFile {
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;
    private int maxBlock;
    private static byte[] identifier = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static int NUM_BIG_BLOCK_DEPOT_BLOCKS_POS = 44;
    private static int SMALL_BLOCK_DEPOT_BLOCK_POS = 60;
    private static int ROOT_START_BLOCK_POS = 48;
    private static int BIG_BLOCK_SIZE = 512;
    private static int SMALL_BLOCK_SIZE = 64;
    private static int EXTENSION_BLOCK_POS = 68;
    private static int NUM_EXTENSION_BLOCK_POS = 72;
    private static int PROPERTY_STORAGE_BLOCK_SIZE = 128;
    private static int BIG_BLOCK_DEPOT_BLOCKS_POS = 76;
    private static int SIZE_OF_NAME_POS = 64;
    private static int TYPE_POS = 66;
    private static int START_BLOCK_POS = 116;
    private static int SIZE_POS = 120;

    public CompoundFile(byte[] d) throws BiffException {
        this.data = d;
        for (int i = 0; i < identifier.length; ++i) {
            if (this.data[i] == identifier[i]) continue;
            throw new BiffException(BiffException.unrecognizedOLEFile);
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[NUM_BIG_BLOCK_DEPOT_BLOCKS_POS], this.data[NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 1], this.data[NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 2], this.data[NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 3]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[SMALL_BLOCK_DEPOT_BLOCK_POS], this.data[SMALL_BLOCK_DEPOT_BLOCK_POS + 1], this.data[SMALL_BLOCK_DEPOT_BLOCK_POS + 2], this.data[SMALL_BLOCK_DEPOT_BLOCK_POS + 3]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[ROOT_START_BLOCK_POS], this.data[ROOT_START_BLOCK_POS + 1], this.data[ROOT_START_BLOCK_POS + 2], this.data[ROOT_START_BLOCK_POS + 3]);
        this.extensionBlock = IntegerHelper.getInt(this.data[EXTENSION_BLOCK_POS], this.data[EXTENSION_BLOCK_POS + 1], this.data[EXTENSION_BLOCK_POS + 2], this.data[EXTENSION_BLOCK_POS + 3]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[NUM_EXTENSION_BLOCK_POS], this.data[NUM_EXTENSION_BLOCK_POS + 1], this.data[NUM_EXTENSION_BLOCK_POS + 2], this.data[NUM_EXTENSION_BLOCK_POS + 3]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        int pos = BIG_BLOCK_DEPOT_BLOCKS_POS;
        int bbdBlocks = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            bbdBlocks = (BIG_BLOCK_SIZE - BIG_BLOCK_DEPOT_BLOCKS_POS) / 4;
        }
        for (int i = 0; i < bbdBlocks; ++i) {
            this.bigBlockDepotBlocks[i] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
            pos += 4;
        }
        for (int j = 0; j < this.numExtensionBlocks; ++j) {
            pos = (this.extensionBlock + 1) * BIG_BLOCK_SIZE;
            int blocksToRead = Math.min(this.numBigBlockDepotBlocks - bbdBlocks, BIG_BLOCK_SIZE / 4 - 1);
            for (int i = bbdBlocks; i < bbdBlocks + blocksToRead; ++i) {
                this.bigBlockDepotBlocks[i] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
                pos += 4;
            }
            if ((bbdBlocks += blocksToRead) >= this.numBigBlockDepotBlocks) continue;
            this.extensionBlock = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private void readBigBlockDepot() {
        int pos = 0;
        int index = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * BIG_BLOCK_SIZE / 4];
        for (int i = 0; i < this.numBigBlockDepotBlocks; ++i) {
            pos = (this.bigBlockDepotBlocks[i] + 1) * BIG_BLOCK_SIZE;
            for (int j = 0; j < BIG_BLOCK_SIZE / 4; ++j) {
                this.bigBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
            }
        }
    }

    private void readSmallBlockDepot() {
        int pos = 0;
        int index = 0;
        int sbdBlock = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        while (sbdBlock != -2) {
            int[] oldChain = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + BIG_BLOCK_SIZE / 4];
            System.arraycopy(oldChain, 0, this.smallBlockChain, 0, oldChain.length);
            pos = (sbdBlock + 1) * BIG_BLOCK_SIZE;
            for (int j = 0; j < BIG_BLOCK_SIZE / 4; ++j) {
                this.smallBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
            }
            sbdBlock = this.bigBlockChain[sbdBlock];
        }
    }

    private void readPropertySets() {
        byte[] d = null;
        for (int offset = 0; offset < this.rootEntry.length; offset += PROPERTY_STORAGE_BLOCK_SIZE) {
            d = new byte[PROPERTY_STORAGE_BLOCK_SIZE];
            System.arraycopy(this.rootEntry, offset, d, 0, d.length);
            PropertyStorage ps = new PropertyStorage(this, d);
            this.propertySets.add(ps);
        }
    }

    public byte[] getStream(String streamName) throws BiffException {
        PropertyStorage ps = this.getPropertyStorage(streamName);
        if (ps.size >= 4096 || streamName.equalsIgnoreCase("root entry")) {
            return this.getBigBlockStream(ps);
        }
        return this.getSmallBlockStream(ps);
    }

    private PropertyStorage getPropertyStorage(String name) throws BiffException {
        Iterator i = ((AbstractList)this.propertySets).iterator();
        boolean found = false;
        PropertyStorage ps = null;
        while (!found && i.hasNext()) {
            ps = (PropertyStorage)i.next();
            if (!ps.name.equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return ps;
    }

    private byte[] getBigBlockStream(PropertyStorage ps) {
        int numBlocks = ps.size / BIG_BLOCK_SIZE;
        if (ps.size % BIG_BLOCK_SIZE != 0) {
            ++numBlocks;
        }
        byte[] streamData = new byte[numBlocks * BIG_BLOCK_SIZE];
        int block = ps.startBlock;
        int count = 0;
        int pos = 0;
        while (block != -2) {
            pos = (block + 1) * BIG_BLOCK_SIZE;
            System.arraycopy(this.data, pos, streamData, count * BIG_BLOCK_SIZE, BIG_BLOCK_SIZE);
            ++count;
            block = this.bigBlockChain[block];
        }
        return streamData;
    }

    private byte[] getSmallBlockStream(PropertyStorage ps) throws BiffException {
        PropertyStorage rootps = this.getPropertyStorage("root entry");
        byte[] rootdata = this.readData(rootps.startBlock);
        byte[] data = new byte[]{};
        int block = ps.startBlock;
        boolean count = false;
        int pos = 0;
        while (block != -2) {
            byte[] olddata = data;
            data = new byte[olddata.length + SMALL_BLOCK_SIZE];
            System.arraycopy(olddata, 0, data, 0, olddata.length);
            pos = block * SMALL_BLOCK_SIZE;
            System.arraycopy(rootdata, pos, data, olddata.length, SMALL_BLOCK_SIZE);
            block = this.smallBlockChain[block];
        }
        return data;
    }

    private byte[] readData(int bl) {
        int block = bl;
        int pos = 0;
        byte[] entry = new byte[]{};
        while (block != -2) {
            byte[] oldEntry = entry;
            entry = new byte[oldEntry.length + BIG_BLOCK_SIZE];
            System.arraycopy(oldEntry, 0, entry, 0, oldEntry.length);
            pos = (block + 1) * BIG_BLOCK_SIZE;
            System.arraycopy(this.data, pos, entry, oldEntry.length, BIG_BLOCK_SIZE);
            block = this.bigBlockChain[block];
        }
        return entry;
    }

    private class PropertyStorage {
        public String name;
        public int type;
        public int startBlock;
        public int size;

        public PropertyStorage(CompoundFile this$0, byte[] data) {
            int nameSize = IntegerHelper.getInt(data[SIZE_OF_NAME_POS], data[SIZE_OF_NAME_POS + 1]);
            this.type = data[TYPE_POS];
            this$0.maxBlock = data.length / BIG_BLOCK_SIZE - 1;
            this.startBlock = IntegerHelper.getInt(data[START_BLOCK_POS], data[START_BLOCK_POS + 1], data[START_BLOCK_POS + 2], data[START_BLOCK_POS + 3]);
            this.size = IntegerHelper.getInt(data[SIZE_POS], data[SIZE_POS + 1], data[SIZE_POS + 2], data[SIZE_POS + 3]);
            int chars = 0;
            if (nameSize > 2) {
                chars = (nameSize - 1) / 2;
            }
            StringBuffer n = new StringBuffer("");
            for (int i = 0; i < chars; ++i) {
                n.append((char)data[i * 2]);
            }
            this.name = n.toString();
        }
    }
}

