/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import xlrd.CellType;
import xlrd.NumberCell;
import xlrd.biff.CellValue;
import xlrd.biff.FormattingRecords;
import xlrd.biff.IntegerHelper;
import xlrd.biff.RKHelper;
import xlrd.biff.Record;

class RKRecord
extends CellValue
implements NumberCell {
    private double value;
    private int xfIndex;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public RKRecord(Record t, FormattingRecords fr) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.xfIndex = IntegerHelper.getInt(data[4], data[5]);
        int rknum = IntegerHelper.getInt(data[6], data[7], data[8], data[9]);
        this.value = RKHelper.getDouble(rknum);
        this.format = fr.getNumberFormat(this.xfIndex);
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public int getXFIndex() {
        return this.xfIndex;
    }
}

