/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;
import xlrd.biff.RecordData;

class XFRecord
extends RecordData {
    private int formatRecord;
    private boolean date;
    private boolean number;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private static int[] dateFormats = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47};
    private static DateFormat[] javaDateFormats = new DateFormat[]{new SimpleDateFormat("M/d/yy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM"), new SimpleDateFormat("MMM-yy"), new SimpleDateFormat("h:mm a"), new SimpleDateFormat("h:mm:ss a"), new SimpleDateFormat("H:mm"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("M/d/yy H:mm"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("mm:ss.S")};
    private static int[] numberFormats = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 37, 38, 39, 40, 41, 42, 43, 44, 48};
    private static NumberFormat[] javaNumberFormats = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.00"), new DecimalFormat("#,##0"), new DecimalFormat("#,##0.00"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("0%"), new DecimalFormat("0.00%"), new DecimalFormat("0.00E00"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("##0.0E0")};

    public XFRecord(Record t) {
        super(t);
        int i;
        byte[] data = this.getRecord().getData();
        this.formatRecord = IntegerHelper.getInt(data[2], data[3]);
        this.date = false;
        this.number = false;
        for (i = 0; i < dateFormats.length; ++i) {
            if (this.formatRecord != dateFormats[i]) continue;
            this.date = true;
            this.dateFormat = javaDateFormats[i];
        }
        for (i = 0; i < numberFormats.length; ++i) {
            if (this.formatRecord != numberFormats[i]) continue;
            this.number = true;
            this.numberFormat = javaNumberFormats[i];
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public int getFormatRecord() {
        return this.formatRecord;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isNumber() {
        return this.number;
    }
}

